package comparator;
import java.util.Comparator;

// OBSERVER BIEN LA CLASSE ANONYME IMBRIQUEE
// static ==> une et une seule instanciation de ces comparateurs
public class ComparatorEmployee {
	static final Comparator<Employee> AGE_ORDER = new Comparator<Employee>() {
		public int compare(Employee emp1, Employee emp2) {
			int emp1Age = emp1.getAge();        
			int emp2Age = emp2.getAge();

			if(emp1Age > emp2Age)
				return 1;
			else if(emp1Age < emp2Age)
				return -1;
			else
				return 0;    
		}
	};		
	
	static final Comparator<Employee> NAME_ORDER = new Comparator<Employee>() {
		public int compare(Employee emp1, Employee emp2){    
			//parameter are of type Object, so we have to downcast it to Employee objects
			String emp1Name = ((Employee)emp1).getName();        
			String emp2Name = ((Employee)emp2).getName();

			//uses compareTo method of String class to compare names of the employee
			return emp1Name.compareTo(emp2Name);
		}
	};		
}

